// Destination Cards Data & Functionality
document.addEventListener('DOMContentLoaded', function() {
    // Destination data
    const destinationData = {
        regions: [
            {
                name: "Europe eSIM",
                subtitle: "40+ Countries Covered",
                image: "https://i.pinimg.com/1200x/f2/ee/dc/f2eedce1e5bc4f3c28ad73f06035ad44.jpg",
                features: ["5G Ready", "Instant Activation", "From $4.99"]
            },
            {
                name: "Asia eSIM",
                subtitle: "25+ Countries Covered",
                image: "https://i.pinimg.com/736x/3a/26/97/3a2697313a5f0f39408bc4845c95c75e.jpg",
                features: ["5G Ready", "Instant Activation", "From $5.99"]
            },
            {
                name: "North America eSIM",
                subtitle: "USA + Canada + Mexico",
                image: "https://i.pinimg.com/736x/66/0a/8d/660a8db1fca92c90a011018da23c2d4b.jpg",
                features: ["5G Ready", "Instant Activation", "From $6.99"]
            },
            {
                name: "South America eSIM",
                subtitle: "12+ Countries Covered",
                image: "https://i.pinimg.com/736x/ac/14/30/ac1430c0eb5213dc67dadee1d5d3350b.jpg",
                features: ["5G Ready", "Instant Activation", "From $4.99"]
            },
            {
                name: "Africa eSIM",
                subtitle: "50+ Countries Covered",
                image: "https://i.pinimg.com/736x/e1/97/6a/e1976ae4da21df06c700953bce4e5abb.jpg",
                features: ["4G Ready", "Instant Activation", "From $5.99"]
            },
            {
                name: "Oceania eSIM",
                subtitle: "Australia + New Zealand",
                image: "https://i.pinimg.com/736x/38/2d/7f/382d7ffc4b4671715cb8989a506f2527.jpg",
                features: ["5G Ready", "Instant Activation", "From $7.99"]
            }
        ],
        countries: [
            {
                name: "France eSIM",
                subtitle: "Europe",
                image: "https://i.pinimg.com/736x/99/ab/49/99ab495e2df1bcd4b3936c172707719c.jpg",
                features: ["5G Ready", "Instant Activation", "From $3.99"]
            },
            {
                name: "Japan eSIM",
                subtitle: "Asia",
                image: "https://i.pinimg.com/1200x/f5/89/37/f589373a2d171963023aa69e165cc217.jpg",
                features: ["5G Ready", "Instant Activation", "From $4.99"]
            },
            {
                name: "United States eSIM",
                subtitle: "North America",
                image: "https://i.pinimg.com/1200x/1d/1a/fa/1d1afa8feb89e0fc4be0de08dd50255b.jpg",
                features: ["5G Ready", "Instant Activation", "From $5.99"]
            },
            {
                name: "United Kingdom eSIM",
                subtitle: "Europe",
                image: "https://i.pinimg.com/1200x/89/c0/36/89c036d10173ab859d07b6005bfda5d5.jpg",
                features: ["5G Ready", "Instant Activation", "From $3.99"]
            },
            {
                name: "Thailand eSIM",
                subtitle: "Asia",
                image: "https://i.pinimg.com/736x/d1/6a/69/d16a695abf40aaf823bde4b57bfe7482.jpg",
                features: ["5G Ready", "Instant Activation", "From $4.49"]
            },
            {
                name: "Germany eSIM",
                subtitle: "Europe",
                image: "https://i.pinimg.com/1200x/d5/97/03/d597035d8187552a830b7c4b98e7d1b5.jpg",
                features: ["5G Ready", "Instant Activation", "From $3.99"]
            },
            {
                name: "Australia eSIM",
                subtitle: "Oceania",
                image: "https://i.pinimg.com/736x/d0/cc/ee/d0ccee89e611dc6e098b0a6ea01e3cd5.jpg",
                features: ["5G Ready", "Instant Activation", "From $6.99"]
            },
            {
                name: "Brazil eSIM",
                subtitle: "South America",
                image: "https://i.pinimg.com/736x/fe/cc/12/fecc125c356d2977ed614b7e0a2f5d18.jpg",
                features: ["4G Ready", "Instant Activation", "From $4.99"]
            }
        ],
        popular: [
            {
                name: "USA eSIM",
                subtitle: "Most Popular",
                image: "https://i.pinimg.com/1200x/1d/1a/fa/1d1afa8feb89e0fc4be0de08dd50255b.jpg",
                features: ["5G Ready", "Instant Activation", "From $5.99"]
            },
            {
                name: "Japan eSIM",
                subtitle: "Most Popular",
                 image: "https://i.pinimg.com/1200x/f5/89/37/f589373a2d171963023aa69e165cc217.jpg",
                features: ["5G Ready", "Instant Activation", "From $4.99"]
            },
            {
                name: "France eSIM",
                subtitle: "Most Popular",
                image: "https://i.pinimg.com/736x/99/ab/49/99ab495e2df1bcd4b3936c172707719c.jpg",
                features: ["5G Ready", "Instant Activation", "From $3.99"]
            },
            {
                name: "UK eSIM",
                subtitle: "Most Popular",
                image: "https://i.pinimg.com/1200x/89/c0/36/89c036d10173ab859d07b6005bfda5d5.jpg",
                features: ["5G Ready", "Instant Activation", "From $3.99"]
            }
        ]
    };

    // Render cards function
    function renderCards(type) {
        const container = document.querySelector('.destination-cards-container');
        const data = destinationData[type];
        
        if (!container || !data) return;

        // fade container out, replace content, then stagger fade-in
        container.style.opacity = 0;

        setTimeout(() => {
            container.innerHTML = data.map(item => {
                const priceFeature = (item.features || []).find(f => /\$\d/.test(f) || /from\s+\$?/i.test(f));
                const priceText = priceFeature || (item.features && item.features[item.features.length - 1]) || '';

                return `
            <div class="esim-card">
                <img src="${item.image || ''}" alt="${item.name || ''}" class="esim-image">
                <div class="esim-content">
                    <h2>${item.name || ''}</h2>
                    <p>${item.subtitle || ''}</p>
                    <div class="esim-meta">
                        <span>${priceText}</span>
                    </div>
                    <button class="esim-btn">View Plans</button>
                </div>
            </div>`;
            }).join('');

            // stagger reveal
            const cards = Array.from(container.querySelectorAll('.esim-card'));
            cards.forEach((card, i) => {
                card.classList.remove('show');
                setTimeout(() => card.classList.add('show'), i * 80);
            });

            container.style.opacity = 1;
        }, 120);
    }

    // Filter button click handlers
    const filterButtons = document.querySelectorAll('.filter-btn');
    
    filterButtons.forEach(btn => {
        btn.addEventListener('click', function() {
            // Remove active class from all buttons
            filterButtons.forEach(b => b.classList.remove('active'));
            // Add active class to clicked button
            this.classList.add('active');

            // Get the type from button data-type or trimmed text
            const raw = this.dataset.type || this.textContent;
            const type = String(raw).trim().toLowerCase();

            if (!destinationData[type]) {
                console.warn('Unknown filter type:', type);
                return;
            }

            renderCards(type);
        });
    });

    // Initial render - Regions shown first
    renderCards('countries');
});
