
        (function () {
            const hamburger = document.getElementById('hamburger');
            const navMenu = document.getElementById('navMenu');
            const nav = document.querySelector('nav');

            if (!hamburger || !navMenu) return;

            function openMenu() {
                hamburger.classList.add('open');
                navMenu.classList.add('open');
                hamburger.setAttribute('aria-expanded', 'true');
                navMenu.setAttribute('aria-hidden', 'false');
                document.body.classList.add('menu-open');
            }

            function closeMenu() {
                hamburger.classList.remove('open');
                navMenu.classList.remove('open');
                hamburger.setAttribute('aria-expanded', 'false');
                navMenu.setAttribute('aria-hidden', 'true');
                document.body.classList.remove('menu-open');
            }

            hamburger.addEventListener('click', () => {
                if (navMenu.classList.contains('open')) closeMenu(); else openMenu();
            });

            // Close when a link is clicked
            navMenu.querySelectorAll('a').forEach(link => {
                link.addEventListener('click', closeMenu);
            });

            // Close on outside click
            document.addEventListener('click', (e) => {
                if (!navMenu.contains(e.target) && !hamburger.contains(e.target)) {
                    closeMenu();
                }
            });

            // Close on Escape
            document.addEventListener('keydown', (e) => {
                if (e.key === 'Escape') closeMenu();
            });

            // Glassmorphism navbar on scroll
            const heroContainer = document.querySelector('.hero-container');

            function handleScroll() {
                if (!heroContainer) return;

                const heroBottom = heroContainer.offsetHeight;
                const scrollY = window.scrollY || window.pageYOffset;

                if (scrollY > heroBottom - 100) {
                    nav.classList.add('scrolled');
                } else {
                    nav.classList.remove('scrolled');
                }
            }

            window.addEventListener('scroll', handleScroll);
            handleScroll(); // Check on page load
        })();


        document.querySelectorAll('.faq-question').forEach(button => {
            button.addEventListener('click', () => {
                const item = button.parentElement;
                item.classList.toggle('active');
            });
        });
   