// Render simplicity cards from a JS data array
document.addEventListener('DOMContentLoaded', function () {
  const items = [
    {
      label: 'Global Coverage',
      title: 'Stay connected in 150+ countries',
      desc: 'Activate one eSIM and enjoy seamless data access across Europe, Asia, the Americas, and beyond — no SIM swapping required.',
      image: 'Assets/img-1.png'
    },
    {
      label: 'Flexible Plans',
      title: 'Flexible data plans for every journey',
      desc: 'Choose daily, weekly, or monthly plans based on your travel needs. Upgrade anytime without hidden charges.',
      image: 'Assets/img-2.png'
    },
    {
      label: 'Quick Setup',
      title: 'Get online in under 2 minutes',
      desc: 'Purchase, scan the QR code, and connect instantly. No store visits. No waiting. Just seamless setup.',
      image: 'Assets/img-3.png'
    },
    {
      label: 'Smart Technology',
      title: 'Always connect to the strongest network',
      desc: 'Flecible automatically connects you to the best available local carrier for faster and more stable data.',
      image: 'Assets/img-4.png'
    },
    {
      label: 'Always Here',
      title: 'Real support, anytime you need it',
      desc: 'Our global support team is available 24/7 to help you with activation, troubleshooting, or plan changes.',
      image: 'Assets/img-5.png'
    },
    {
      label: 'No Hidden Fees',
      title: 'What you see is what you pay, no extra fees',
      desc: 'No roaming surprises. No hidden costs. Just simple, upfront pricing for stress-free travel.',
      image: 'Assets/img-6.png'
    }
  ];

  const container = document.querySelector('.simplicity-card-container');
  if (!container) return;

  // build markup
  container.innerHTML = items.map(item => `
    <div class="simplicity-card">
      <img src="${item.image}" alt="${item.title}" class="simplicity-image">
      <div class="simplicity-content">
        <div class="simplicity-label">${item.label}</div>
        <div class="simplicity-title">${item.title}</div>
        <div class="simplicity-desc">${item.desc}</div>
      </div>
    </div>
  `).join('');

  // optional: stagger reveal
  const cards = Array.from(container.querySelectorAll('.simplicity-card'));
  cards.forEach((c, i) => {
    c.style.opacity = 0;
    c.style.transform = 'translateY(12px)';
    setTimeout(() => {
      c.style.transition = 'opacity 360ms ease, transform 360ms cubic-bezier(.2,.9,.2,1)';
      c.style.opacity = 1;
      c.style.transform = 'translateY(0)';
    }, i * 80);
  });
});