
const testimonials = [

  {
    name: "Lucas Andersen",
    title: "Travel Consultant, Denmark",
    quote: "I activated my plan before boarding, and the moment I landed in Singapore, I was connected. Zero friction.",
    avatar: "https://i.pravatar.cc/100?img=11"
  },
  {
    name: "Isabella Rossi",
    title: "Marketing Director, Italy",
    quote: "Flecible makes international travel feel local. No roaming surprises, no searching for SIM cards.",
    avatar: "https://i.pravatar.cc/100?img=5"
  },
  {
    name: "Ethan Walker",
    title: "Management Consultant, USA",
    quote: "I travel weekly for work. Flecible is now part of my travel checklist simple, reliable, and fast.",
    avatar: "https://i.pravatar.cc/100?img=14"
  },
  {
    name: "Yuki Tanaka",
    title: "Product Manager, Japan",
    quote: "The activation process is incredibly smooth. Everything is clear, minimal, and efficient.",
    avatar: "https://i.pravatar.cc/100?img=48"
  },
  {
    name: "Sofia Alvarez",
    title: "Digital Creator, Spain",
    quote: "I love being able to choose the exact data plan I need for each country. It feels tailored.",
    avatar: "https://i.pravatar.cc/100?img=29"
  },
  {
    name: "Noah Thompson",
    title: "Software Engineer, Canada",
    quote: "Setup took less than two minutes. That level of simplicity is rare in telecom.",
    avatar: "https://i.pravatar.cc/100?img=52"
  },
  {
    name: "Hannah Müller",
    title: "Freelance Designer, Germany",
    quote: "Switching between countries without changing physical SIM cards is a game changer.",
    avatar: "https://i.pravatar.cc/100?img=23"
  },
  {
    name: "Omar Khalid",
    title: "Entrepreneur, UAE",
    quote: "Reliable connection, transparent pricing, and real support when needed. Exactly what travelers want.",
    avatar: "https://i.pravatar.cc/100?img=36"
  },
  {
    name: "Camila Ferreira",
    title: "Business Analyst, Brazil",
    quote: "I used Flecible across three countries in one trip. It worked flawlessly in all of them.",
    avatar: "https://i.pravatar.cc/100?img=41"
  },
  {
    name: "Oliver Bennett",
    title: "Startup Founder, UK",
    quote: "It feels like a modern telecom product fast, clean, and designed with travelers in mind.",
    avatar: "https://i.pravatar.cc/100?img=64"
  }

];

const N = testimonials.length;
let current = 2;
let direction = 'right';
let isAnimating = false;
let cardEls = [];
const carousel = document.getElementById('carousel');

function getDiff(i) {
  let d = i - current;
  while (d >  Math.floor(N / 2)) d -= N;
  while (d < -Math.floor(N / 2)) d += N;
  return d;
}

function posClass(d) {
  if (d === 0)  return 'pos-active';
  if (d === -1) return 'pos-prev';
  if (d ===  1) return 'pos-next';
  if (d <= -2)  return 'pos-prev2';
  return 'pos-next2';
}

function applyPositions(animate) {
  cardEls.forEach((card, i) => {
    const d   = getDiff(i);
    const pos = posClass(d);

    // Strip all managed classes
    card.classList.remove(
      'pos-active','pos-prev','pos-next','pos-prev2','pos-next2','pos-hidden',
      'from-right','from-left','animate'
    );

    card.classList.add(pos);

    if (animate) {
      if (pos === 'pos-active') {
        // Force reflow so animation restarts cleanly
        void card.offsetWidth;
        card.classList.add(direction === 'right' ? 'from-right' : 'from-left');
      } else {
        card.classList.add('animate');
      }
    }
  });
}

function navigate(newIndex) {
  if (isAnimating) return;
  isAnimating = true;
  current = newIndex;
  applyPositions(true);
  setTimeout(() => { isAnimating = false; }, 460);
}

// Build DOM once
testimonials.forEach((t, i) => {
  const card = document.createElement('div');
  card.className = 'card';
  card.innerHTML = `
    <div class="card-top">
      <div class="avatar"><img src="${t.avatar}" alt="${t.name}" loading="lazy"></div>
      <div class="quote-icon">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M19.4167 6.67891C20.4469 7.77257 21.0001 9 21.0001 10.9897C21.0001 14.4891 18.5436 17.6263 14.9695 19.1768L14.0768 17.7992C17.4121 15.9946 18.0639 13.6539 18.3245 12.178C17.7875 12.4557 17.0845 12.5533 16.3954 12.4895C14.591 12.3222 13.1689 10.8409 13.1689 9C13.1689 7.067 14.7359 5.5 16.6689 5.5C17.742 5.5 18.7681 5.99045 19.4167 6.67891ZM9.41669 6.67891C10.4469 7.77257 11.0001 9 11.0001 10.9897C11.0001 14.4891 8.54359 17.6263 4.96951 19.1768L4.07682 17.7992C7.41206 15.9946 8.06392 13.6539 8.32447 12.178C7.78747 12.4557 7.08452 12.5533 6.39539 12.4895C4.59102 12.3222 3.16895 10.8409 3.16895 9C3.16895 7.067 4.73595 5.5 6.66895 5.5C7.742 5.5 8.76814 5.99045 9.41669 6.67891Z"></path></svg>
      </div>
    </div>
    <p class="quote-text">${t.quote}</p>
    <p class="attribution">- ${t.name}, ${t.title}</p>
  `;
  card.addEventListener('click', () => {
    if (i === current || isAnimating) return;
    direction = getDiff(i) > 0 ? 'right' : 'left';
    navigate(i);
  });
  carousel.appendChild(card);
  cardEls.push(card);
});

applyPositions(false); // initial placement, no animation

document.getElementById('prevBtn').addEventListener('click', () => {
  if (isAnimating) return;
  direction = 'left';
  navigate((current - 1 + N) % N);
});

document.getElementById('nextBtn').addEventListener('click', () => {
  if (isAnimating) return;
  direction = 'right';
  navigate((current + 1) % N);
});

// Swipe support
let tx = 0;
carousel.addEventListener('touchstart', e => { tx = e.touches[0].clientX; }, { passive: true });
carousel.addEventListener('touchend',   e => {
  if (isAnimating) return;
  const dx = e.changedTouches[0].clientX - tx;
  if (Math.abs(dx) > 40) {
    if (dx < 0) { direction = 'right'; navigate((current + 1) % N); }
    else        { direction = 'left';  navigate((current - 1 + N) % N); }
  }
}, { passive: true });
